<?php

header('Content-Type: application/json');

// Verifica User-Agent
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$allowedAgent = 'MyAppName/1.0';  // coloque o user-agent usado no app

if (strpos($userAgent, $allowedAgent) === false) {
    // Requisição não autorizada
    http_response_code(403);
    echo json_encode(['error' => 'Acesso negado']);
    exit();
}

header('Content-Type: application/json');

// Define o caminho para o banco de dados
$db_path = __DIR__ . '/studiolivecode.db';

// Conecta ao banco de dados
try {
    $db = new PDO("sqlite:$db_path");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Seleciona todas as URLs de DNS
    $stmt = $db->prepare("SELECT url FROM dns");
    $stmt->execute();

    // Obtém os resultados como um array de strings
    $dns_list = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);

    // Retorna a lista em formato JSON
    echo json_encode($dns_list);

} catch (PDOException $e) {
    // Retorna um erro JSON se algo der errado
    http_response_code(500); // Internal Server Error
    echo json_encode(['error' => 'Erro interno do servidor: ' . $e->getMessage()]);
}

exit();
?>