<?php
/*
 * 🎵 @ Playlist Manager - Dashboard
 * 🚀 @ Version: 1.0.0
 * 📅 @ Last Updated: 28/06/2025
 */

include "includes/header.php";
?>

<style>
/* Efeito de escala no hover */
.card i {
    transition: transform 0.3s ease, color 0.3s ease;
}

.card:hover i {
    transform: scale(1.3);
    color: #fff700; /* amarelo claro no hover */
}

/* Efeito pulsante contínuo */
@keyframes pulse {
    0% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.1); opacity: 0.8; }
    100% { transform: scale(1); opacity: 1; }
}

.card i.fa-3x {
    animation: pulse 3s infinite;
}
</style>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12 text-center mb-4">
            <h2><i class="fas fa-home"></i> Dashboard Principal</h2>
            <p class="lead">Bem-vindo ao painel de gerenciamento de playlists e configurações do sistema.</p>
        </div>
    </div>

    <div class="row justify-content-center">

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-info text-white">
                <div class="card-body">
                    <i class="fas fa-server fa-3x mb-3"></i>
                    <h5 class="card-title">Servidores de DNS</h5>
                    <p class="card-text">Gerencie os servidores DNS para seus Clientes.</p>
                    <a href="dns.php" class="btn btn-light btn-block">Acessar DNS</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-primary text-white">
                <div class="card-body">
                    <i class="fas fa-image fa-3x mb-3"></i>
                    <h5 class="card-title">Altera logotipo</h5>
                    <p class="card-text">Envie ou atualize o logotipo do Aplicativo.</p>
                    <a href="logo.php" class="btn btn-light btn-block">Alterar Logotipo</a>
                </div>
            </div>
        </div>

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-warning text-white">
                <div class="card-body">
                    <i class="fas fa-image fa-3x mb-3"></i>
                    <h5 class="card-title">Alterar Fundo</h5>
                    <p class="card-text">Envie ou atualize a imagem de fundo do sistema.</p>
                    <a href="Image.php" class="btn btn-light btn-block">Alterar Fundo</a>
                </div>
            </div>
        </div>

       

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-success text-white">
                <div class="card-body">
                    <i class="fas fa-comment-alt fa-3x mb-3"></i>
                    <h5 class="card-title">Mensagem Servidores</h5>
                    <p class="card-text">Envie mensagens para os servidores.</p>
                    <a href="settings.php" class="btn btn-light btn-block">Configurar Mensagens</a>
                </div>
            </div>
        </div>

        

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-info text-white">
                <div class="card-body">
                    <i class="fas fa-qrcode fa-3x mb-3"></i>
                    <h5 class="card-title">Alterar QR Code</h5>
                    <p class="card-text">Atualize o código QR do seu sistema.</p>
                    <a href="qrcode.php" class="btn btn-light btn-block">Alterar QR Code</a>
                </div>
            </div>
        </div>

        

        <div class="col-md-4 col-sm-6 mb-4">
            <div class="card text-center bg-dark text-white">
                <div class="card-body">
                    <i class="fas fa-user-cog fa-3x mb-3"></i>
                    <h5 class="card-title">Meu Perfil</h5>
                    <p class="card-text">Acesse e gerencie suas informações de perfil.</p>
                    <a href="user.php" class="btn btn-light btn-block">Acessar Perfil</a>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include "includes/footer.php"; ?>
