<?php
header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
header("Pragma: no-cache"); // HTTP 1.0.
header("Expires: 0"); // Proxies.
include "includes/header.php";
?>

<style>
    /* Estilos Gerais */
    .custom-button {
        padding: 10px 20px;
        border-radius: 5px;
        transition: background-color 0.3s ease;
    }

    .custom-button:hover {
        opacity: 0.9;
    }

    .custom-input {
        color: #007bff; /* Azul vibrante para o texto do input */
        border: 1px solid #ced4da;
        border-radius: 4px;
        padding: 8px 12px;
        width: 100%; /* Ocupa a largura total do container */
        box-sizing: border-box; /* Inclui padding e borda na largura total */
    }

    /* Estilos para os Cards */
    .card {
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1); /* Sombra mais suave e evidente */
        margin-bottom: 20px;
    }

    .card-header {
        background-color: #f8f9fa; /* Fundo claro para o cabeçalho do card */
        border-bottom: 1px solid #e9ecef;
        padding: 15px 20px;
        border-top-left-radius: 10px; /* Arredonda os cantos superiores */
        border-top-right-radius: 10px;
    }

    .card-title {
        color: #343a40;
        font-weight: 600;
        display: flex; /* Para alinhar ícone e texto */
        align-items: center;
        justify-content: center; /* Centraliza o título */
    }

    .card-title i {
        margin-right: 10px; /* Espaço entre o ícone e o texto */
        font-size: 1.25rem; /* Tamanho do ícone */
    }

    /* Estilos dos Botões de Ação */
    .btn-action {
        background-color: #28a745; /* Verde para botões de sucesso */
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
        margin-top: 15px; /* Espaço acima dos botões */
    }

    .btn-action:hover {
        background-color: #218838; /* Verde mais escuro ao passar o mouse */
    }

    .btn-info-modal { /* Estilo para o botão "Como Usar" */
        background-color: #17a2b8;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
        margin-top: 15px;
        margin-left: 10px;
    }

    .btn-info-modal:hover {
        background-color: #138496;
    }

    /* Estilos para o Seletor de Modo (Cards) */
    .mode-selection-card {
        cursor: pointer;
        border: 2px solid #e9ecef;
        transition: all 0.3s ease;
        padding: 25px; /* Mais padding para um visual mais aberto */
        text-align: center;
        background-color: #fff;
        border-radius: 10px;
        display: flex; /* Para centralizar conteúdo verticalmente */
        flex-direction: column;
        justify-content: center;
        align-items: center;
        min-height: 180px; /* Altura mínima para os cards */
    }

    .mode-selection-card:hover {
        border-color: #007bff;
        box-shadow: 0 6px 15px rgba(0,0,0,0.15);
        transform: translateY(-3px);
    }

    .mode-selection-card.selected {
        border-color: #007bff; /* Azul para seleção */
        box-shadow: 0 6px 15px rgba(0,123,255,0.2); /* Sombra azul para seleção */
        background-color: #e6f2ff; /* Fundo levemente azulado quando selecionado */
    }

    .mode-selection-card .icon {
        font-size: 3.5rem; /* Ícones maiores */
        margin-bottom: 15px;
        color: #6c757d;
    }

    .mode-selection-card.selected .icon {
        color: #007bff; /* Ícone azul quando selecionado */
    }

    .mode-selection-card h4 {
        margin-bottom: 10px;
        color: #343a40;
        font-weight: 600;
    }

    .mode-selection-card p {
        font-size: 0.95rem;
        color: #6c757d;
    }

    /* Esconde os formulários inicialmente */
    #qr-code-form, #image-upload-form {
        display: none;
        margin-top: 30px; /* Espaço antes dos formulários */
        padding: 20px;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        background-color: #fcfcfc;
    }

    /* Estilos para mensagens de feedback */
    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
    }

    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
    }

    .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
    }
</style>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Gerenciamento de QR Code 📱</h1>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary card-title">
                <i class="fa fa-hand-pointer"></i> Escolha o Modo de Operação
            </h6>
        </div>
        <div class="card-body">
            <p class="text-center mb-4">Selecione como você deseja gerenciar seu QR Code:</p>

            <form id="modeSelectionForm">
                <input type="hidden" name="selected_mode" id="selectedModeInput" value="">

                <div class="row justify-content-center">
                    <div class="col-md-5 mb-3">
                        <div class="card mode-selection-card" data-mode="qr">
                            <div class="card-body">
                                <div class="icon">🔗</div> <h4>Gerar QR Code (Celular)</h4>
                                <p>Crie um QR Code diretamente a partir de um número de celular.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-5 mb-3">
                        <div class="card mode-selection-card" data-mode="image">
                            <div class="card-body">
                                <div class="icon">🖼️</div> <h4>Carregar Imagem de QR Code</h4>
                                <p>Faça upload de uma imagem PNG existente do seu QR Code.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

            <hr class="my-4"> <div id="qr-code-form">
                <h5 class="text-primary mb-3">Gerar QR Code a Partir de Celular 📞</h5>
                <form action="gerarqrcode.php" method="post">
                    <div class="form-group">
                        <label for="phone_number">Insira o número de celular (Ex: 5511996200241 para Brasil)</label>
                        <input type="text" id="phone_number" name="url" class="form-control custom-input" placeholder="Ex: 5511996200241" required>
                    </div>
                    <button type="submit" class="btn btn-action"><i class="fa fa-qrcode"></i> Gerar QR Code</button>
                </form>
            </div>

            <div id="image-upload-form">
                <h5 class="text-primary mb-3">Carregar Imagem de QR Code (PNG) ⬆️</h5>
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="image">Selecione a imagem (Apenas arquivos PNG)</label>
                        <input type="file" name="image" id="image" accept="image/png" class="form-control-file" required>
                    </div>
                    <button type="submit" class="btn btn-action"><i class="fa fa-upload"></i> Enviar Imagem</button>
                </form>

                <?php
                // Verifica se o formulário foi enviado para carregar a imagem
                if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["image"])) {
                    $fileType = $_FILES["image"]["type"];
                    if ($fileType === "image/png") {
                        $uploadPath = './api/qr/';
                        $fileName = 'qr.png';
                        $filePath = $uploadPath . $fileName;

                        // Cria o diretório se não existir
                        if (!is_dir($uploadPath)) {
                            mkdir($uploadPath, 0777, true);
                        }

                        if (move_uploaded_file($_FILES["image"]["tmp_name"], $filePath)) {
                            echo '<div class="alert alert-success" role="alert">✅ Imagem enviada com sucesso!</div>';

                            // Conectar ao banco de dados e salvar os dados
                            try {
                                $pdo = new PDO('sqlite:' . __DIR__ . '/api/studiolivecode.db');
                                $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                                // Insere "1" no título e o caminho no URL
                                // Considera que `qrcode` tabela tem `title` e `url`
                                // Se a tabela não existir, você precisará criá-la (ex: CREATE TABLE qrcode (id INTEGER PRIMARY KEY, title TEXT, url TEXT);)
                                $stmt = $pdo->prepare("INSERT INTO qrcode (title, url) VALUES (?, ?)");
                                $stmt->execute([1, '/api/qr/qr.png']); // O URL deve ser acessível publicamente
                                echo '<div class="alert alert-info" role="alert">💾 Dados salvos no banco de dados com sucesso.</div>';
                            } catch (PDOException $e) {
                                echo '<div class="alert alert-danger" role="alert">❌ Erro ao salvar no banco de dados: ' . $e->getMessage() . '</div>';
                            }
                        } else {
                            echo '<div class="alert alert-danger" role="alert">❌ Falha ao enviar a imagem. Verifique as permissões da pasta.</div>';
                        }
                    } else {
                        echo '<div class="alert alert-danger" role="alert">⚠️ Apenas arquivos PNG são permitidos.</div>';
                    }
                }
                ?>
            </div>
        </div>
    </div>
</div>

<?php
include "includes/footer.php";
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const modeSelectionCards = document.querySelectorAll('.mode-selection-card');
        const qrCodeForm = document.getElementById('qr-code-form');
        const imageUploadForm = document.getElementById('image-upload-form');
        const selectedModeInput = document.getElementById('selectedModeInput');

        // Função para mostrar o formulário e atualizar a seleção do card
        function showForm(selectedMode) {
            qrCodeForm.style.display = 'none';
            imageUploadForm.style.display = 'none';

            if (selectedMode === 'qr') {
                qrCodeForm.style.display = 'block';
            } else if (selectedMode === 'image') {
                imageUploadForm.style.display = 'block';
            }

            // Atualiza a classe 'selected' nos cards
            modeSelectionCards.forEach(card => {
                card.classList.remove('selected');
                if (card.dataset.mode === selectedMode) {
                    card.classList.add('selected');
                }
            });

            // Atualiza o valor do input oculto
            selectedModeInput.value = selectedMode;
        }

        // Adiciona listeners de clique aos cards de seleção de modo
        modeSelectionCards.forEach(card => {
            card.addEventListener('click', function() {
                showForm(this.dataset.mode);
            });
        });

        // Opcional: Se quiser que um formulário seja exibido por padrão ao carregar a página
        // showForm('qr'); // Descomente para que o "Gerar QR Code" seja o padrão
    });
</script>